#ifndef _PANEL_LIST_H_
#define _PANEL_LIST_H_




typedef void (*PanelListItemKillProc)(UInt32 crid,char* name,BitmapPtr icon,BitmapPtr iconS);

struct Panel;

typedef struct{
	
	char name[32];
	UInt32 num;
	struct Panel** panels;
	
}Category;

typedef struct{
	
	char name[32];
	UInt32 crid;
	BitmapPtr icon;
	BitmapPtr iconS;
	Category* category;
	
}Panel;

typedef struct{
	
	UInt32 numPanels;
	UInt32 numCategories;
	Panel** panels;
	Category** categories;
	PanelListItemKillProc itemKillF;
	
}PanelList;


PanelList* PanelListCreate(PanelListItemKillProc itemKillF);
void PanelListDestroy(PanelList* list);
void PanelListAddPanel(PanelList* list,UInt32 crid,BitmapPtr icon,BitmapPtr iconS,char* name,char* category);
void PanelListSort(PanelList* list);
UInt32 PanelListGetNumPanels(PanelList* list);
UInt32 PanelListGetNumCategories(PanelList* list);
void PanelListGetNthPanel(PanelList* list,UInt32 n,UInt32* crid,BitmapPtr* icon,BitmapPtr* iconS,char* name,UInt32* categoryIdx);
void PanelListGetNthCategory(PanelList* list,UInt32 n,char* name,UInt32* numPanels);
void PanelListGetNthPanelInCategory(PanelList* list,UInt32 catIdx,UInt32 n,UInt32* crid,BitmapPtr* icon,BitmapPtr* iconS,char* name);






#endif //_PANEL_LIST_H_